# 🛡️ Parental Control Monitoring System

## Complete Real-Time Child Monitoring Solution

A comprehensive parental control system with Android app and web-based admin panel for real-time monitoring of children's phone activities.

---

## 🌟 Features

### ✅ Current Features
- **Real-Time SMS Monitoring** - View all SMS messages instantly
- **Call Log Tracking** - Monitor incoming/outgoing calls with duration
- **Live Notifications** - Auto-refresh dashboard every 5 seconds
- **Multi-Device Support** - Monitor multiple children's devices
- **Background Service** - Works silently in background
- **Auto-Start on Boot** - Service starts automatically after phone restart
- **No Play Protect Issues** - Works without disabling Play Protect
- **Web-Based Dashboard** - Access from any browser
- **Secure Authentication** - Admin login required

### 🚧 Upcoming Features
- Gmail OTP Monitoring
- Installed Apps List
- Real-Time Location Tracking
- Screenshot Capture
- WhatsApp Message Monitoring

---

## 📁 Project Structure

```
ParentalControlApp/
├── Android_App/                    # Android Application
│   └── app/
│       ├── src/main/
│       │   ├── java/.../
│       │   │   ├── MainActivity.java
│       │   │   ├── MonitoringService.java
│       │   │   ├── SmsReceiver.java
│       │   │   ├── CallReceiver.java
│       │   │   └── BootReceiver.java
│       │   ├── res/
│       │   │   ├── layout/
│       │   │   │   └── activity_main.xml
│       │   │   └── values/
│       │   │       └── strings.xml
│       │   └── AndroidManifest.xml
│       └── build.gradle
│
├── PHP_Backend/                    # Backend API & Admin
│   ├── api/
│   │   ├── config.php             # Database configuration
│   │   ├── register.php           # Device registration
│   │   ├── save_sms.php           # Save SMS data
│   │   ├── save_call.php          # Save call logs
│   │   └── get_data.php           # Get live data
│   └── admin/
│       ├── index.php              # Admin login
│       ├── dashboard.php          # Live dashboard
│       └── logout.php             # Logout handler
│
├── database.sql                    # Database schema
├── INSTALLATION_GUIDE_BANGLA.md   # Installation guide (Bengali)
└── README.md                       # This file
```

---

## 🚀 Quick Start

### Prerequisites
- InfinityFree (or any PHP hosting)
- MySQL Database
- Android Studio (for building APK)
- PHP 7.4+ with MySQLi extension

### Installation Steps

1. **Setup Database**
   - Create MySQL database on InfinityFree
   - Import `database.sql` via phpMyAdmin

2. **Upload PHP Files**
   - Upload `PHP_Backend` folder to `htdocs`
   - Edit `api/config.php` with your database credentials

3. **Build Android App**
   - Open `Android_App` in Android Studio
   - Update API URLs in Java files
   - Build APK

4. **Deploy**
   - Install APK on child's phone
   - Access admin panel at: `https://yourdomain.com/admin/`

📖 **Detailed Instructions**: See [INSTALLATION_GUIDE_BANGLA.md](INSTALLATION_GUIDE_BANGLA.md)

---

## 🔐 Default Credentials

### Admin Panel
- **URL**: https://yourdomain.com/admin/
- **Email**: admin@monitor.com
- **Password**: admin123

⚠️ **Security Note**: Change these credentials in production!

---

## 📊 Database Schema

### Tables

1. **devices** - Registered devices information
   - device_id, child_name, parent_name, parent_email

2. **sms_messages** - SMS message logs
   - device_id, sender, message, received_at

3. **call_logs** - Call history
   - device_id, phone_number, call_type, duration

4. **applications** - Installed apps (future)

5. **gmail_otp_logs** - Gmail OTP codes (future)

---

## 🛠️ Technology Stack

### Backend
- PHP 7.4+
- MySQL 5.7+
- JSON REST API

### Frontend
- HTML5, CSS3, JavaScript
- Vanilla JS (No frameworks)
- Real-time AJAX polling

### Mobile
- Android SDK 21+
- Java
- Volley for HTTP requests

---

## 📱 Android Permissions

Required permissions:
- `READ_SMS` - Read SMS messages
- `RECEIVE_SMS` - Receive new SMS
- `READ_CALL_LOG` - Access call history
- `READ_PHONE_STATE` - Monitor phone state
- `READ_CONTACTS` - Access contacts
- `FOREGROUND_SERVICE` - Background service
- `RECEIVE_BOOT_COMPLETED` - Auto-start

---

## 🔄 API Endpoints

### Registration
```
POST /api/register.php
Parameters: device_id, child_name, parent_name, parent_email
```

### Save SMS
```
POST /api/save_sms.php
Parameters: device_id, sender, message, received_at
```

### Save Call
```
POST /api/save_call.php
Parameters: device_id, phone_number, call_type, call_status, duration, call_time
```

### Get Data
```
GET /api/get_data.php
Parameters: device_id (optional), type (sms/calls/devices/all), limit
```

---

## 🐛 Troubleshooting

### Problem: Database Connection Failed
**Solution**: 
- Check database credentials in `api/config.php`
- Verify database exists in phpMyAdmin

### Problem: App not sending data
**Solution**:
- Check internet connection
- Verify all permissions granted
- Disable battery optimization for the app

### Problem: Admin panel not showing data
**Solution**:
- Check browser console (F12)
- Verify API URLs are correct
- Clear browser cache

---

## 📝 Development Notes

### For Developers

1. **Android App Customization**
   - Package name: `com.monitor.parentalcontrol`
   - Change in: `AndroidManifest.xml` and Java files

2. **Admin Panel Customization**
   - Auto-refresh interval: Line 215 in `dashboard.php`
   - Default: 5000ms (5 seconds)

3. **Database Configuration**
   - Host, username, password: `api/config.php`
   - Character set: UTF-8 (utf8mb4)

---

## 🔒 Security Considerations

1. **Change Default Credentials** - Update admin login credentials
2. **Use HTTPS** - Enable SSL certificate on hosting
3. **Input Validation** - All inputs are sanitized
4. **SQL Injection Protection** - Prepared statements used
5. **XSS Prevention** - Output escaping implemented

---

## 📞 Support

For issues and questions:
1. Check the [Installation Guide](INSTALLATION_GUIDE_BANGLA.md)
2. Review troubleshooting section
3. Verify all files are uploaded correctly

---

## 📄 License

This project is provided as-is for educational and parental monitoring purposes. Use responsibly and in accordance with local laws.

---

## 🙏 Acknowledgments

- Developed for parents who want to keep their children safe online
- Built with InfinityFree hosting compatibility in mind
- Optimized for low-resource environments

---

## 📈 Version History

### Version 1.0 (December 2024)
- Initial release
- SMS monitoring
- Call log tracking
- Real-time dashboard
- Multi-device support

---

**Developer**: Parental Control Team  
**Contact**: admin@monitor.com  
**Last Updated**: December 2024

---

## ⭐ Star this project if you find it useful!
