# ⚡ দ্রুত সেটআপ গাইড (আপনার ভাইয়ের জন্য)

## 🎯 মাত্র 5 টি ধাপে সম্পূর্ণ সেটআপ!

---

## ধাপ ১: ডাটাবেস তৈরি করুন (2 মিনিট)

1. InfinityFree Control Panel → **MySQL Databases**
2. **Create Database** ক্লিক করুন
3. এই তথ্যগুলো লিখে রাখুন:
   ```
   Database Name: _____________
   Username: _____________
   Password: _____________
   Host: sql108.infinityfree.com
   ```

4. **phpMyAdmin** → আপনার ডাটাবেস সিলেক্ট করুন
5. **Import** ট্যাব → `database.sql` ফাইল আপলোড করুন
6. **Go** ক্লিক করুন

✅ **সফল হলে**: "Import has been successfully finished" দেখাবে

---

## ধাপ ২: PHP ফাইল আপলোড করুন (3 মিনিট)

1. File Manager → `htdocs` ফোল্ডারে যান

2. `PHP_Backend` ফোল্ডার থেকে সবকিছু আপলোড করুন:
   - `api` ফোল্ডার (পুরোটা)
   - `admin` ফোল্ডার (পুরোটা)

3. ফাইনাল স্ট্রাকচার এমন হবে:
   ```
   htdocs/
   ├── api/
   │   ├── config.php
   │   ├── register.php
   │   ├── save_sms.php
   │   ├── save_call.php
   │   └── get_data.php
   └── admin/
       ├── index.php
       ├── dashboard.php
       └── logout.php
   ```

✅ **চেক করুন**: `htdocs/api/config.php` ফাইল আছে কিনা

---

## ধাপ ৩: Database Configuration (1 মিনিট)

1. File Manager → `htdocs/api/config.php` ফাইল খুলুন

2. এই লাইনগুলো **আপনার তথ্য দিয়ে** পরিবর্তন করুন:

```php
define('DB_HOST', 'sql108.infinityfree.com');
define('DB_USER', 'আপনার_ইউজারনেম');      // ⬅️ এখানে
define('DB_PASS', 'আপনার_পাসওয়ার্ড');      // ⬅️ এখানে
define('DB_NAME', 'আপনার_ডাটাবেস_নাম');    // ⬅️ এখানে
```

3. **Save Changes** ক্লিক করুন

✅ **সফল হলে**: ফাইল সেভ হয়ে যাবে

---

## ধাপ ৪: টেস্ট করুন (2 মিনিট)

### Admin Panel টেস্ট:
1. ব্রাউজারে যান: `https://yourdomain.com/admin/`
2. লগইন করুন:
   - Email: `admin@monitor.com`
   - Password: `admin123`
3. Dashboard দেখতে পেলে সফল! ✅

### API টেস্ট:
ব্রাউজারে টেস্ট করুন:
```
https://yourdomain.com/api/get_data.php?type=devices
```

দেখাবে:
```json
{"success":true,"data":{"devices":[...]}}
```

✅ **সফল হলে**: JSON ডেটা দেখাবে

---

## ধাপ ৫: Android App সেটআপ (শুধু URL পরিবর্তন)

যদি Android Studio থাকে:

1. `Android_App` ফোল্ডার ওপেন করুন

2. এই 3 টি ফাইলে **শুধু URL পরিবর্তন** করুন:

**MainActivity.java** (Line 31):
```java
private String API_URL = "https://yourdomain.com/api/";
```

**SmsReceiver.java** (Line 19):
```java
private static final String API_URL = "https://yourdomain.com/api/";
```

**CallReceiver.java** (Line 17):
```java
private static final String API_URL = "https://yourdomain.com/api/";
```

3. Build → Build APK
4. APK রেডি!

---

## 🎉 সেটআপ সম্পূর্ণ!

### এখন কি করবেন:

1. **Admin Panel লিংক পাঠান**:
   ```
   URL: https://yourdomain.com/admin/
   Email: admin@monitor.com
   Password: admin123
   ```

2. **APK পাঠান** (যদি বিল্ড করে থাকেন)

3. **চেক করুন**:
   - ✅ Admin Panel লগইন হচ্ছে
   - ✅ Dashboard খুলছে
   - ✅ টেস্ট ডিভাইস দেখা যাচ্ছে

---

## ⚠️ যদি কোন সমস্যা হয়:

### সমস্যা: "Database connection failed"
**সমাধান**: `api/config.php` ফাইলের তথ্য চেক করুন

### সমস্যা: Admin Panel খুলছে না
**সমাধান**: 
- File Manager এ গিয়ে দেখুন `htdocs/admin/index.php` আছে কিনা
- URL সঠিক আছে কিনা চেক করুন

### সমস্যা: JSON দেখাচ্ছে না
**সমাধান**: Database সঠিকভাবে ইমপোর্ট হয়েছে কিনা চেক করুন

---

## 📞 এক্সট্রা সাহায্য

যদি কিছু বুঝতে সমস্যা হয়:
1. `INSTALLATION_GUIDE_BANGLA.md` ফাইল পড়ুন (বিস্তারিত গাইড)
2. প্রতিটি ধাপ ধীরে ধীরে করুন
3. স্ক্রিনশট নিয়ে রাখুন

---

## ✅ চেকলিস্ট

সব ঠিক আছে কিনা চেক করুন:
- [ ] Database তৈরি হয়েছে
- [ ] database.sql ইমপোর্ট হয়েছে
- [ ] PHP ফাইল আপলোড হয়েছে
- [ ] config.php আপডেট করা হয়েছে
- [ ] Admin Panel খুলছে
- [ ] API কাজ করছে

সবগুলোতে ✓ দিতে পারলে সম্পূর্ণ সফল! 🎊

---

**নোট**: পুরো প্রসেসে সর্বোচ্চ 10-15 মিনিট সময় লাগবে।

**সৌভাগ্য কামনা করছি!** 🚀
