<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$device_id = isset($_POST['device_id']) ? trim($_POST['device_id']) : '';
$phone_number = isset($_POST['phone_number']) ? trim($_POST['phone_number']) : '';
$call_type = isset($_POST['call_type']) ? trim($_POST['call_type']) : 'incoming';
$call_status = isset($_POST['call_status']) ? trim($_POST['call_status']) : '';
$duration = isset($_POST['duration']) ? intval($_POST['duration']) : 0;
$call_time = isset($_POST['call_time']) ? trim($_POST['call_time']) : date('Y-m-d H:i:s');

// Validation
if (empty($device_id) || empty($phone_number)) {
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

$conn = getDBConnection();

// Verify device exists
$stmt = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$stmt->bind_param("s", $device_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'message' => 'Device not registered']);
    exit;
}

// Insert call log
$stmt = $conn->prepare("INSERT INTO call_logs (device_id, phone_number, call_type, call_status, duration, call_time, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
$stmt->bind_param("ssssis", $device_id, $phone_number, $call_type, $call_status, $duration, $call_time);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Call log saved successfully',
        'call_id' => $stmt->insert_id
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to save call log: ' . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
