<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$device_id = isset($_POST['device_id']) ? trim($_POST['device_id']) : '';
$child_name = isset($_POST['child_name']) ? trim($_POST['child_name']) : '';
$parent_name = isset($_POST['parent_name']) ? trim($_POST['parent_name']) : '';
$parent_email = isset($_POST['parent_email']) ? trim($_POST['parent_email']) : '';

// Validation
if (empty($device_id) || empty($child_name) || empty($parent_name) || empty($parent_email)) {
    echo json_encode(['success' => false, 'message' => 'All fields are required']);
    exit;
}

if (!filter_var($parent_email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email format']);
    exit;
}

$conn = getDBConnection();

// Check if device already registered
$stmt = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$stmt->bind_param("s", $device_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Update existing device
    $stmt = $conn->prepare("UPDATE devices SET child_name = ?, parent_name = ?, parent_email = ?, updated_at = NOW() WHERE device_id = ?");
    $stmt->bind_param("ssss", $child_name, $parent_name, $parent_email, $device_id);
} else {
    // Insert new device
    $stmt = $conn->prepare("INSERT INTO devices (device_id, child_name, parent_name, parent_email, created_at) VALUES (?, ?, ?, ?, NOW())");
    $stmt->bind_param("ssss", $device_id, $child_name, $parent_name, $parent_email);
}

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => 'Registration successful',
        'device_id' => $device_id
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Registration failed: ' . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
