# 🚀 Parental Control Monitoring System
## সম্পূর্ণ ইনস্টলেশন গাইড (বাংলা)

---

## 📦 প্যাকেজ সম্পর্কে

এই সিস্টেমে রয়েছে:
1. ✅ **Android App** - শিশুর ফোনে ইন্সটল করার জন্য
2. ✅ **PHP Backend** - InfinityFree হোস্টিং এ আপলোড করার জন্য
3. ✅ **Admin Panel** - লাইভ মনিটরিং এর জন্য
4. ✅ **Database** - ডেটা সংরক্ষণের জন্য

---

## 🎯 ধাপ ১: হোস্টিং সেটআপ

### 1.1 InfinityFree হোস্টিং এ লগইন করুন
- যান: https://infinityfree.net
- আপনার অ্যাকাউন্টে লগইন করুন

### 1.2 নতুন ডাটাবেস তৈরি করুন
1. Control Panel → MySQL Databases
2. "Create Database" এ ক্লিক করুন
3. ডাটাবেস তথ্য সেভ করুন:
   - **Database Name**: (যেমন: epiz_12345_monitor)
   - **Database Username**: (যেমন: epiz_12345)
   - **Database Password**: (আপনার পাসওয়ার্ড)
   - **Database Host**: sql108.infinityfree.com

### 1.3 phpMyAdmin এ ডাটাবেস ইমপোর্ট করুন
1. Control Panel → phpMyAdmin
2. আপনার ডাটাবেস সিলেক্ট করুন
3. উপরে "Import" ট্যাবে ক্লিক করুন
4. "Choose File" → `database.sql` ফাইল সিলেক্ট করুন
5. "Go" বাটনে ক্লিক করুন
6. সফল মেসেজ দেখলে সম্পন্ন!

---

## 🎯 ধাপ ২: PHP ফাইল আপলোড

### 2.1 File Manager এ যান
- Control Panel → File Manager
- `htdocs` ফোল্ডারে যান

### 2.2 ফাইল আপলোড করুন
1. `PHP_Backend` ফোল্ডার থেকে সব ফাইল আপলোড করুন:
   ```
   htdocs/
   ├── api/
   │   ├── config.php
   │   ├── register.php
   │   ├── save_sms.php
   │   ├── save_call.php
   │   └── get_data.php
   └── admin/
       ├── index.php
       ├── dashboard.php
       └── logout.php
   ```

### 2.3 Database Configuration সেটআপ
1. File Manager এ `api/config.php` ফাইল খুলুন
2. নিচের লাইনগুলো আপডেট করুন:

```php
define('DB_HOST', 'sql108.infinityfree.com');    // আপনার হোস্ট
define('DB_USER', 'epiz_12345');                 // আপনার ইউজারনেম
define('DB_PASS', 'your_password_here');         // আপনার পাসওয়ার্ড
define('DB_NAME', 'epiz_12345_monitor');         // আপনার ডাটাবেস নাম
```

3. "Save Changes" ক্লিক করুন

---

## 🎯 ধাপ ৩: Android App সেটআপ

### 3.1 Android Studio তে প্রজেক্ট খুলুন
1. Android Studio ওপেন করুন
2. "Open an Existing Project"
3. `Android_App` ফোল্ডার সিলেক্ট করুন

### 3.2 API URL আপডেট করুন
নিচের ফাইলগুলোতে URL পরিবর্তন করুন:

**MainActivity.java** (Line 31):
```java
private String API_URL = "https://yourdomain.com/api/";
```

**SmsReceiver.java** (Line 19):
```java
private static final String API_URL = "https://yourdomain.com/api/";
```

**CallReceiver.java** (Line 17):
```java
private static final String API_URL = "https://yourdomain.com/api/";
```

### 3.3 APK বিল্ড করুন
1. Android Studio → Build → Build Bundle(s) / APK(s) → Build APK(s)
2. বিল্ড সম্পন্ন হলে "locate" এ ক্লিক করুন
3. APK ফাইল পাবেন: `app/build/outputs/apk/debug/app-debug.apk`

---

## 🎯 ধাপ ৪: টেস্টিং

### 4.1 Admin Panel টেস্ট করুন
1. ব্রাউজারে যান: `https://yourdomain.com/admin/`
2. লগইন করুন:
   - **Email**: admin@monitor.com
   - **Password**: admin123
3. Dashboard দেখতে পাবেন

### 4.2 Android App টেস্ট করুন
1. শিশুর ফোনে APK ইন্সটল করুন
2. সব পারমিশন দিন (SMS, Calls, Contacts)
3. রেজিস্ট্রেশন ফর্ম পূরণ করুন
4. "রেজিস্টার করুন" ক্লিক করুন

### 4.3 লাইভ ডেটা চেক করুন
1. শিশুর ফোনে একটি টেস্ট SMS পাঠান
2. Admin Panel এ যান → SMS ট্যাব
3. 5 সেকেন্ডের মধ্যে SMS দেখা যাবে

---

## 🔗 গুরুত্বপূর্ণ লিংক

### অ্যাডমিন প্যানেল
- **URL**: https://yourdomain.com/admin/
- **Email**: admin@monitor.com
- **Password**: admin123

### API এন্ডপয়েন্ট
- রেজিস্ট্রেশন: https://yourdomain.com/api/register.php
- SMS সেভ: https://yourdomain.com/api/save_sms.php
- Call সেভ: https://yourdomain.com/api/save_call.php
- ডেটা রিড: https://yourdomain.com/api/get_data.php

---

## ⚙️ বৈশিষ্ট্য

### ✅ যা কাজ করে
- ✅ রিয়েল-টাইম SMS মনিটরিং
- ✅ কল লগ ট্র্যাকিং
- ✅ লাইভ নোটিফিকেশন (প্রতি 5 সেকেন্ডে অটো-রিফ্রেশ)
- ✅ মাল্টিপল ডিভাইস সাপোর্ট
- ✅ Play Protect এর প্রয়োজন নেই
- ✅ ব্যাকগ্রাউন্ড সার্ভিস
- ✅ বুট পরে অটো-স্টার্ট

### 🚧 ভবিষ্যতে যুক্ত হবে
- Gmail OTP মনিটরিং
- ইন্সটলড অ্যাপস তালিকা
- রিয়েল-টাইম লোকেশন ট্র্যাকিং
- স্ক্রিনশট ক্যাপচার

---

## 🔧 সমস্যা সমাধান

### সমস্যা ১: Database Connection Failed
**সমাধান**:
- `api/config.php` ফাইলে ডাটাবেস তথ্য চেক করুন
- phpMyAdmin এ লগইন করে দেখুন ডাটাবেস আছে কিনা

### সমস্যা ২: App ডেটা পাঠায় না
**সমাধান**:
- ইন্টারনেট কানেকশন চেক করুন
- অ্যাপে সব পারমিশন দেওয়া আছে কিনা দেখুন
- Battery Optimization অফ করুন

### সমস্যা ৩: Admin Panel ডেটা দেখায় না
**সমাধান**:
- F12 চেপে Console চেক করুন
- API URL সঠিক আছে কিনা দেখুন
- Browser ক্যাশ ক্লিয়ার করুন

---

## 📞 সাপোর্ট

যদি কোন সমস্যা হয়:
1. প্রথমে এই গাইড আবার পড়ুন
2. `database.sql` ফাইল সঠিকভাবে ইমপোর্ট হয়েছে কিনা চেক করুন
3. সব ফাইল সঠিক জায়গায় আপলোড করেছেন কিনা দেখুন

---

## 🎉 সফল সেটআপ!

যদি সব ঠিকমতো হয়:
- ✅ Admin Panel লগইন হচ্ছে
- ✅ Android App রেজিস্টার হয়েছে
- ✅ লাইভ SMS/Call ডেটা দেখাচ্ছে

তাহলে আপনার সিস্টেম সম্পূর্ণ রেডি! 🎊

---

## 📝 নোট

- প্রথমবার সেটআপে 10-15 মিনিট সময় লাগতে পারে
- Admin Panel প্রতি 5 সেকেন্ডে অটো-রিফ্রেশ হয়
- শিশুর ফোনে ইন্টারনেট সবসময় চালু থাকতে হবে
- অ্যাপ আনইন্সটল হলে আবার ইন্সটল করুন

---

**ডেভেলপড বাই**: Parental Control Team  
**ভার্সন**: 1.0  
**তারিখ**: ডিসেম্বর 2024
