<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Only POST method allowed']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);

$device_id = $data['device_id'] ?? '';
$child_name = $data['child_name'] ?? '';
$parent_name = $data['parent_name'] ?? '';
$parent_email = $data['parent_email'] ?? '';

if (empty($device_id) || empty($child_name) || empty($parent_name) || empty($parent_email)) {
    echo json_encode(['success' => false, 'message' => 'All fields required']);
    exit();
}

if (!filter_var($parent_email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Invalid email']);
    exit();
}

$conn = getDBConnection();

$check = $conn->prepare("SELECT id FROM devices WHERE device_id = ?");
$check->bind_param("s", $device_id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    $update = $conn->prepare("UPDATE devices SET child_name=?, parent_name=?, parent_email=?, updated_at=NOW() WHERE device_id=?");
    $update->bind_param("ssss", $child_name, $parent_name, $parent_email, $device_id);
    
    if ($update->execute()) {
        echo json_encode(['success' => true, 'message' => 'Device updated']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Update failed']);
    }
} else {
    $insert = $conn->prepare("INSERT INTO devices (device_id, child_name, parent_name, parent_email) VALUES (?, ?, ?, ?)");
    $insert->bind_param("ssss", $device_id, $child_name, $parent_name, $parent_email);
    
    if ($insert->execute()) {
        echo json_encode(['success' => true, 'message' => 'Device registered']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Registration failed']);
    }
}

$conn->close();
?>
