package com.monitor.parentalcontrol;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.telephony.TelephonyManager;

import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CallReceiver extends BroadcastReceiver {

    private static final String API_URL = "https://myapplicationapp.infinityfreeapp.com/api/";
    private static String lastCallNumber = "";
    private static long callStartTime = 0;

    @Override
    public void onReceive(Context context, Intent intent) {
        String state = intent.getStringExtra(TelephonyManager.EXTRA_STATE);
        String phoneNumber = intent.getStringExtra(TelephonyManager.EXTRA_INCOMING_NUMBER);

        if (state == null) return;

        switch (state) {
            case TelephonyManager.EXTRA_STATE_RINGING:
                // Incoming call
                lastCallNumber = phoneNumber != null ? phoneNumber : "Unknown";
                sendCallToServer(context, lastCallNumber, "incoming", "ringing");
                break;

            case TelephonyManager.EXTRA_STATE_OFFHOOK:
                // Call answered
                callStartTime = System.currentTimeMillis();
                if (!lastCallNumber.isEmpty()) {
                    sendCallToServer(context, lastCallNumber, "incoming", "answered");
                }
                break;

            case TelephonyManager.EXTRA_STATE_IDLE:
                // Call ended
                if (!lastCallNumber.isEmpty() && callStartTime > 0) {
                    long duration = (System.currentTimeMillis() - callStartTime) / 1000;
                    sendCallToServer(context, lastCallNumber, "incoming", "ended", duration);
                    lastCallNumber = "";
                    callStartTime = 0;
                }
                break;
        }
    }

    private void sendCallToServer(Context context, String phoneNumber, String callType, 
                                   String status) {
        sendCallToServer(context, phoneNumber, callType, status, 0);
    }

    private void sendCallToServer(Context context, String phoneNumber, String callType, 
                                   String status, long duration) {
        SharedPreferences prefs = context.getSharedPreferences("MonitorPrefs", Context.MODE_PRIVATE);
        String deviceId = Settings.Secure.getString(context.getContentResolver(), 
            Settings.Secure.ANDROID_ID);

        if (!prefs.getBoolean("isRegistered", false)) {
            return;
        }

        String url = API_URL + "save_call.php";

        // Format timestamp
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        String formattedTime = sdf.format(new Date());

        RequestQueue queue = Volley.newRequestQueue(context);
        StringRequest request = new StringRequest(Request.Method.POST, url,
            new Response.Listener<String>() {
                @Override
                public void onResponse(String response) {
                    // Call log saved successfully
                }
            },
            new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    // Error handling
                }
            }) {
            @Override
            protected Map<String, String> getParams() {
                Map<String, String> params = new HashMap<>();
                params.put("device_id", deviceId);
                params.put("phone_number", phoneNumber);
                params.put("call_type", callType);
                params.put("call_status", status);
                params.put("duration", String.valueOf(duration));
                params.put("call_time", formattedTime);
                return params;
            }
        };

        queue.add(request);
    }
}
